{smcl}
{* *! version 1.0.0  3feb2010}{...}
{cmd:help oneDproj}{right:dialog:  {dialog oneDproj}{space 1}}
{right:also see:  {help CI1D}}
{hline}

{title:Title}

{p2colset 5 22 24 2}{...}
{p2col : oneDproj {hline 2}} Implements estimation of the one-dimensional identification regions of BLP coefficients from Beresteanu and 
Molinari (Econometrica, 2008){p_end}
{p2colreset}{...}


{title:Syntax}

{p 8 18 2}
{cmd:oneDproj}
	Ylow Yhigh XProj1 XProj2 ... XOther1 XOther2 ...
	[{cmd:,} {it:options} {cmd:dim(#) nointercept predict(M) contrast(M)}]

{synoptset 24 tabbed}{...}
{synopthdr}
{synoptline}

{synopt :{opt d:im(#)}} Number of components of the BLP coefficient vector to estimate identification regions for, not counting
	the intercept; default is to estimate identification regions for all components of the BLP vector. {p_end}
{synopt :{opt noint:ercept}} Suppress estimation of the identification region for the intercept. {p_end}
{synopt :{opt pred:ict(M)}} Estimates the identification region for the BLP with covariate values specified in matrix M. {p_end}
{synopt :{opt con:trast(M)}} Estimates the identification region for the contrast of BLPs with covariate values specified in matrix M. {p_end}

{title:Description}

{pstd}
{cmd:oneDproj} implements estimation of the identification region for specified components of BLP coefficient vector as described
	in Beresteanu and Molinari (Econometrica, 2008).  Typing

{phang2}
{cmd:. oneDproj} Ylow Yhigh XProj1 XProj2

{pstd}
executes the estimation procedure based on two X variables, displaying lower and upper bounds for the projections
of both X variables specified as XProj1 and XProj2. Note that the Ylow variable contains the lower bounds on the 
dependent variable and the Yhigh variable contains the upper bounds on the dependent variable.

{pstd}
This command should be used with {cmd:CI1D} to calculate critical values and confidence collections/sets 
via nonparametric bootstrap.

{title:Options}

{pstd}
Let p be the number of covariates in the model, including the intercept.

{pstd}
{cmd:predict} estimates the identification region for the BLP with the values of covariates specified in matrix M.
M must be specified as a Stata matrix, must be a p-1 x 1 matrix of covariate values, and must be ordered in the same manner 
as the covariates are listed in the original {cmd:oneDproj} command.  Note that the intercept should not be specified by the user in matrix M.

{pstd}
{cmd:contrast} estimates the identification region for the difference between the BLPs at 
the values of covariates specified in the first column of matrix M and the values of covariates specified in the second 
column of matrix M.  M must be specified as a Stata matrix, must be a p-1 x 2 matrix of covariate values, and must be ordered in the same manner 
as the covariates are listed in the original {cmd:oneDproj} command.  Note that the intercept should not be specified by the user in matrix M.

{title:Examples}

{pstd}Two Xs, one dimension requested without intercept{p_end}
{phang2}{cmd:. oneDproj Ylow Yhigh X1 X2, dim(1) nointercept}{p_end}

{pstd}Two Xs, both dimensions requested with intercept{p_end}
{phang2}{cmd:. oneDproj Ylow Yhigh X1 X2}{p_end}

{pstd}Two Xs, both dimensions requested with intercept, BLP requested{p_end}
{phang2}{cmd:. matrix M = [1\.5]}{p_end}
{phang2}{cmd:. oneDproj Ylow Yhigh X1 X2, predict(M)}{p_end}

{pstd}Two Xs, both dimensions requested with intercept, contrast BLP requested{p_end}
{phang2}{cmd:. matrix M = [1,2\.5,1]}{p_end}
{phang2}{cmd:. oneDproj Ylow Yhigh X1 X2, contrast(M)}{p_end}

{title:Saved results}

{pstd}
{cmd:oneDproj} saves the following in {cmd:e()}:

{synoptset 25 tabbed}
{p2col 5 25 29 2: Scalars}{p_end}
{synopt:{cmd:e(lb_0)}}Lower bound of the estimated identification region for the Intercept{p_end}
{synopt:{cmd:e(ub_0)}}Upper bound of the estimated identification region for the Intercept{p_end}
{synopt:{cmd:e(lb_1)}}Lower bound of the estimated identification region for X1{p_end}
{synopt:{cmd:e(ub_1)}}Upper bound of the estimated identification region for X1{p_end}
{synopt:{cmd:...}}{p_end}
{synopt:{cmd:e(lb_{it:d})}}Lower bound of the estimated identification region for Xd{p_end}
{synopt:{cmd:e(ub_{it:d})}}Upper bound of the estimated identification region for Xd{p_end}

{synoptset 25 tabbed}{...}
{p2col 5 25 29 2: Matrices}{p_end}
{synopt:{cmd:e(Thetahat1D)}}Estimated identification regions for all BLP coefficients{p_end}
{synopt:{cmd:e(ThetahatPred)}}Estimated identification regions for BLP{p_end}
{synopt:{cmd:e(ThetahatPredCon)}}Estimated identification regions for contrast of BLPs{p_end}

{p2colreset}{...}


{title:Also see}

{psee}
{space 2}Help:  {help CI1D}{break}
{p_end}
